//
// EDGE BLEND SHADER
// By Roger Sodre
// Studio Avante 2011
//
// Based on Paul Bourke's
// http://paulbourke.net/texture_colour/edgeblend/
//

uniform sampler2DRect u_tex;				// Syphon texture

uniform vec2	u_texSize;				// texture size
uniform int		u_gamma_curves;			// gamma Curves
uniform float	u_gamma_global;			// gamma GLOBAL
uniform float	u_gamma_global2;		// gamma GLOBAL
uniform float	u_gamma_global3;		// gamma GLOBAL
uniform float	u_gamma_global4;		// gamma GLOBAL
uniform float	u_gamma_global5;		// gamma GLOBAL
uniform vec3	u_gamma_rgb;			// gamma for each RGB channel
uniform vec3	u_gamma_rgb2;			// gamma for each RGB channel
uniform vec3	u_gamma_rgb3;			// gamma for each RGB channel
uniform vec3	u_gamma_rgb4;			// gamma for each RGB channel
uniform vec3	u_gamma_rgb5;			// gamma for each RGB channel
uniform bool	u_alphaMask;			// true: make alpha mask, false: apply to texture


void main()
{
	vec2 uv = gl_TexCoord[0].st;
	vec4 color = vec4(0,0,0,0);
	float a = 1.0;
	
	// Left blend
	if (uv.x <= 0.5)
		a = 1.0 - (uv.x * 2.0);
	// Right blend
	else
		a = ( (uv.x-0.5) * 2.0 );

	float gdy = 1.0 / float(u_gamma_curves);
	float g = u_gamma_global;
	vec3 g3 = u_gamma_rgb;
	if ( uv.y > gdy * 4.0 )
	{
		g = u_gamma_global5;
		g3 = u_gamma_rgb5;
	}
	else if ( uv.y > gdy * 3.0 )
	{
		g = u_gamma_global4;
		g3 = u_gamma_rgb4;
	}
	else if ( uv.y > gdy * 2.0 )
	{
		g = u_gamma_global3;
		g3 = u_gamma_rgb3;
	}
	else if ( uv.y > gdy )
	{
		g = u_gamma_global2;
		g3 = u_gamma_rgb2;
	}

	// Make BLACK ALPHA MASK
	if (u_alphaMask)
	{
		if (a < 1.0)
		{
			a = (1.0 - a);
			color.a = pow( a, g );
			color.r =  (a - pow( a, (1.0/(1.0-g3.r)) ) );
			color.g =  (a - pow( a, (1.0/(1.0-g3.g)) ) );
			color.b =  (a - pow( a, (1.0/(1.0-g3.b)) ) );
			//color = vec4(0,0,0,a);
		}
	}
	// Make BLENDED TEXTURE
	else
	{
		// get texture
		color = texture2DRect(u_tex, uv);
		color.a = 1.0;
		if (a > 0.0 && a < 1.0)
		{
			color.r *= pow( a, (1.0/(g+g3.r)) );
			color.g *= pow( a, (1.0/(g+g3.g)) );
			color.b *= pow( a, (1.0/(g+g3.b)) );
		}
	}

/* dummy colors
if (myPos.x < blend)
color = vec4(0,0,1,1);
else
color = vec4(1,0,1,1);
*/

	// output final color
	//gl_FragColor = vec4(1,0,0,0.5);
	gl_FragColor = color;
}
